//Find and change line weights between certain values
// A Jongware Script 05-Jun-2019
app.doScript(fixHairlines, ScriptLanguage.JAVASCRIPT, undefined, UndoModes.ENTIRE_SCRIPT, "Fix hairlines");

function fixHairlines() {
	var thicknessDialog = app.dialogs.add({ name: "Fix hairlines", canCancel: true });
	with (thicknessDialog) {
		with (dialogColumns.add()) {
			with (dialogRows.add()) {
				staticTexts.add({ staticLabel: "Minimum weight" });
				minweight = measurementEditboxes.add({ editUnits: MeasurementUnits.POINTS, editValue: 0.01, largeNudge: 0.1, smallNudge: 0.01, minimumValue: 0, maximumValue: 999 });
			}
			with (dialogRows.add()) {
				staticTexts.add({ staticLabel: "Maximum weight" });
				maxweight = measurementEditboxes.add({ editUnits: MeasurementUnits.POINTS, editValue: 1.0, largeNudge: 0.1, smallNudge: 0.01, minimumValue: 0, maximumValue: 999 });
			}
			with (dialogRows.add()) {
				staticTexts.add({ staticLabel: "Change to" });
				setweight = measurementEditboxes.add({ editUnits: MeasurementUnits.POINTS, editValue: 1.0, largeNudge: 0.1, smallNudge: 0.01, minimumValue: 0, maximumValue: 999 });
			}
		}
	}
	
	if (thicknessDialog.show() == true) {
		app.findObjectPreferences = null;
		app.findChangeObjectOptions.includeLockedLayersForFind = false;
		app.findChangeObjectOptions.includeLockedStoriesForFind = false;
		list = app.documents[0].findObject();
		for (i = 0; i < list.length; i++) {
			if (list[i].strokeWeight != 0  &&
				list[i].strokeWeight >= minweight.editValue &&
				list[i].strokeWeight <= maxweight.editValue)
			{
				list[i].strokeWeight = setweight.editValue;					
			}

		}
	}
}